import { Repository } from 'typeorm';
import { Payment } from '../../entities/payment.entity';
import { Order } from '../../entities/order.entity';
import { Customer } from '../../entities/customer.entity';
import { StripeService } from './gateways/stripe.service';
import { PaypalService } from './gateways/paypal.service';
import { CreatePaymentDto, ProcessPaymentDto, RefundPaymentDto } from './dto';
export declare class PaymentsService {
    private readonly paymentRepo;
    private readonly orderRepo;
    private readonly customerRepo;
    private readonly stripeService;
    private readonly paypalService;
    getAllPayments: any;
    getPaymentStats(): void;
    processPayment(processPaymentDto: ProcessPaymentDto, customerId: any): import("./dto").PaymentResponseDto | PromiseLike<import("./dto").PaymentResponseDto>;
    createPaymentIntent(createPaymentDto: CreatePaymentDto, customerId: any): import("./dto").PaymentResponseDto | PromiseLike<import("./dto").PaymentResponseDto>;
    constructor(paymentRepo: Repository<Payment>, orderRepo: Repository<Order>, customerRepo: Repository<Customer>, stripeService: StripeService, paypalService: PaypalService);
    createStripePayment(orderId: string, customerId: string): Promise<{
        paymentId: any;
        clientSecret: string | null;
        amount: any;
        currency: any;
    }>;
    createPaypalPayment(orderId: string, customerId: string): Promise<{
        paymentId: any;
        paypalOrderId: any;
        approvalUrl: any;
        amount: any;
        currency: any;
    }>;
    confirmStripePayment(paymentId: string, paymentIntentId: string): Promise<{
        success: boolean;
        payment: Payment;
    }>;
    confirmPaypalPayment(paymentId: string, orderId: string): Promise<{
        success: boolean;
        payment: Payment;
        paypalResponse: any;
    }>;
    getPayment(paymentId: string, customerId: any): Promise<Payment>;
    getCustomerPayments(customerId: string): Promise<Payment[]>;
    refundPayment(paymentId: string, refundPaymentDto: RefundPaymentDto, amount?: number): Promise<{
        refund: any;
        payment: Payment;
    }>;
}
